/*
 * QrfeCache.cpp
 *
 *  Created on: 16.02.2011
 *      Author: stefan.detter
 */

#include "../inc/QrfeCache.h"
#include <QCoreApplication>
#include <QSettings>


QrfeCache QrfeCache::d;

QrfeCache::QrfeCache()
{
	m_settings = 0;
	m_init = false;
}

QrfeCache::~QrfeCache()
{
	if(m_settings != 0)
	{
		if(m_cache.size() > 0)
			m_settings->setValue("Cache", m_cache);
		delete m_settings;
	}
}

void QrfeCache::init ( QString appName )
{
	if(m_init)
		return;

	m_settings = new QSettings(QSettings::IniFormat, QSettings::UserScope, "RF-Embedded", "." + appName + "-Cache");
	m_cache = m_settings->value("Cache", QMap<QString, QVariant>()).toMap();
	m_init = true;
}

QVariant QrfeCache::value(QString key, const QVariant& defaultValue)
{
	if(!m_init)
		return defaultValue;

	if(m_cache.contains(key))
		return m_cache.value(key);
	return defaultValue;
}

void QrfeCache::setValue(QString key, const QVariant& value)
{
	if(!m_init)
		return;

	m_cache.insert(key, value);
	m_settings->setValue("Cache", m_cache);
}

